/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import com.kenai.jaffl.Library;
import com.kenai.jaffl.LibraryOption;
import java.util.HashMap;
import java.util.Map;
import org.python.posix.FreeBSDPOSIX;
import org.python.posix.JavaPOSIX;
import org.python.posix.LazyPOSIX;
import org.python.posix.LibC;
import org.python.posix.LibCProvider;
import org.python.posix.LinuxLibC;
import org.python.posix.LinuxPOSIX;
import org.python.posix.MacOSPOSIX;
import org.python.posix.OpenBSDPOSIX;
import org.python.posix.POSIX;
import org.python.posix.POSIXHandler;
import org.python.posix.POSIXTypeMapper;
import org.python.posix.SolarisPOSIX;
import org.python.posix.WindowsLibC;
import org.python.posix.WindowsLibCFunctionMapper;
import org.python.posix.WindowsPOSIX;
import org.python.posix.util.Platform;

public class POSIXFactory {
    static final String LIBC = Platform.IS_LINUX ? "libc.so.6" : (Platform.IS_WINDOWS ? "msvcrt" : "c");
    static final Map<LibraryOption, Object> defaultOptions = new HashMap<LibraryOption, Object>(){
        {
            this.put(LibraryOption.TypeMapper, POSIXTypeMapper.INSTANCE);
            this.put(LibraryOption.LoadNow, Boolean.TRUE);
        }
    };

    public static POSIX getPOSIX(POSIXHandler pOSIXHandler, boolean bl) {
        return new LazyPOSIX(pOSIXHandler, bl);
    }

    static POSIX loadPOSIX(POSIXHandler pOSIXHandler, boolean bl) {
        POSIX pOSIX;
        block18: {
            pOSIX = null;
            if (bl) {
                try {
                    if (Platform.IS_MAC) {
                        pOSIX = POSIXFactory.loadMacOSPOSIX(pOSIXHandler);
                    } else if (Platform.IS_LINUX) {
                        pOSIX = POSIXFactory.loadLinuxPOSIX(pOSIXHandler);
                    } else if (Platform.IS_FREEBSD) {
                        pOSIX = POSIXFactory.loadFreeBSDPOSIX(pOSIXHandler);
                    } else if (Platform.IS_OPENBSD) {
                        pOSIX = POSIXFactory.loadOpenBSDPOSIX(pOSIXHandler);
                    } else if (Platform.IS_SOLARIS) {
                        pOSIX = POSIXFactory.loadSolarisPOSIX(pOSIXHandler);
                    } else if (Platform.IS_WINDOWS) {
                        pOSIX = POSIXFactory.loadWindowsPOSIX(pOSIXHandler);
                    }
                    if (pOSIXHandler.isVerbose()) {
                        if (pOSIX != null) {
                            System.err.println("Successfully loaded native POSIX impl.");
                        } else {
                            System.err.println("Failed to load native POSIX impl; falling back on Java impl. Unsupported OS.");
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!pOSIXHandler.isVerbose()) break block18;
                    System.err.println("Failed to load native POSIX impl; falling back on Java impl. Stacktrace follows.");
                    throwable.printStackTrace();
                }
            }
        }
        if (pOSIX == null) {
            pOSIX = POSIXFactory.getJavaPOSIX(pOSIXHandler);
        }
        return pOSIX;
    }

    public static POSIX getJavaPOSIX(POSIXHandler pOSIXHandler) {
        return new JavaPOSIX(pOSIXHandler);
    }

    public static POSIX loadLinuxPOSIX(POSIXHandler pOSIXHandler) {
        return new LinuxPOSIX(LIBC, new LinuxLibCProvider(), pOSIXHandler);
    }

    public static POSIX loadMacOSPOSIX(POSIXHandler pOSIXHandler) {
        return new MacOSPOSIX(LIBC, new DefaultLibCProvider(), pOSIXHandler);
    }

    public static POSIX loadSolarisPOSIX(POSIXHandler pOSIXHandler) {
        return new SolarisPOSIX(LIBC, new SolarisLibCProvider(), pOSIXHandler);
    }

    public static POSIX loadFreeBSDPOSIX(POSIXHandler pOSIXHandler) {
        return new FreeBSDPOSIX(LIBC, new DefaultLibCProvider(), pOSIXHandler);
    }

    public static POSIX loadOpenBSDPOSIX(POSIXHandler pOSIXHandler) {
        return new OpenBSDPOSIX(LIBC, new DefaultLibCProvider(), pOSIXHandler);
    }

    public static POSIX loadWindowsPOSIX(POSIXHandler pOSIXHandler) {
        return new WindowsPOSIX(LIBC, new WindowsLibCProvider(), pOSIXHandler);
    }

    private static final class DefaultLibCProvider
    implements LibCProvider {
        private DefaultLibCProvider() {
        }

        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        private static final class SingletonHolder {
            public static LibC libc = Library.loadLibrary(LibC.class, defaultOptions, "c");

            private SingletonHolder() {
            }
        }
    }

    private static final class LinuxLibCProvider
    implements LibCProvider {
        private LinuxLibCProvider() {
        }

        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        private static final class SingletonHolder {
            public static LibC libc = Library.loadLibrary(LinuxLibC.class, defaultOptions, "libc.so.6");

            private SingletonHolder() {
            }
        }
    }

    private static final class SolarisLibCProvider
    implements LibCProvider {
        private SolarisLibCProvider() {
        }

        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        private static final class SingletonHolder {
            public static LibC libc = Library.loadLibrary(LibC.class, defaultOptions, "socket", "nsl", "c");

            private SingletonHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WindowsLibCProvider
    implements LibCProvider {
        private WindowsLibCProvider() {
        }

        @Override
        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        static final Map<LibraryOption, Object> getOptions() {
            HashMap<LibraryOption, Object> hashMap = new HashMap<LibraryOption, Object>(defaultOptions);
            hashMap.put(LibraryOption.FunctionMapper, WindowsLibCFunctionMapper.INSTANCE);
            return hashMap;
        }

        static final class SingletonHolder {
            public static LibC libc = Library.loadLibrary(WindowsLibC.class, WindowsLibCProvider.getOptions(), "msvcrt", "kernel32");

            SingletonHolder() {
            }
        }
    }
}

